#
# Fichier de configuration de Makefile
#

#
# C'est le rpertoire contenant la distribution Enhydra.
#
ENHYDRA_DIR = /usr/local/enhydra3.1
JDKDIR=/jdk1.3

# 
# Rgles de build WML
#
XMLC_WML_OPTS = -domfactory org.enhydra.wireless.wml.WMLDomFactory

#
# C'est le nom du fichier jar  crer.
#
JARNAME = kb

CLASS_OUTPUT=$(ROOT)/classes

#
# Effectue des vrifications avant le build.
#
ENHYDRA_CHECK = YES

include $(ENHYDRA_DIR)/lib/stdrules.mk

$(PACKAGE_OUTPUT)/%WML.class: $(WML_DIR)/%.wml $(XMLC_WML_OPTS_FILE) $(XMLC_%_OPTS_FILE)
	@mkdir -p $(PACKAGE_OUTPUT)
ifeq ($(XMLC_AUTO_COMP),YES)
	cp -f $(WML_DIR)/$*.wml $(PACKAGE_OUTPUT)
endif
	@CLASSPATH="$(ENHYDRA_CLASSPATH)" ; export CLASSPATH ; \
	set -x ; \
	$(XMLC_CMD) -class $(PACKAGE).$*WML $(XMLC_WML_OPTS) $(XMLC_$*_OPTS) $(XMLC_JAVAC) $(XMLC_WML_OPTS_FILE) $(XMLC_$*_OPTS_FILE) $(WML_DIR)/$*.wml

$(PACKAGE_OUTPUT)/%WML.class: %.wml $(XMLC_WML_OPTS_FILE)
	@mkdir -p $(PACKAGE_OUTPUT)
	@CLASSPATH="$(ENHYDRA_CLASSPATH)" ; export CLASSPATH ; \
	set -x ; \
	$(XMLC_CMD) -class $(PACKAGE).$*WML -d $(PACKAGE_OUTPUT) $(XMLC_WML_OPTS) $(XMLC_$*_OPTS) $(XMLC_JAVAC) $(XMLC_WML_OPTS_FILE)  $*.wml

do_xmlc_html_targets:: $(WML_CLASSES:%=${PACKAGE_OUTPUT}/%.class)

#
# Seulement utilis si ENHYDRA_DIR n'est pas correct.
#
$(ENHYDRA_DIR)/lib/stdrules.mk:
	@echo
	@echo "Veuillez modifier config.mk. ENHYDRA_DIR doit pointer vers votre installation d'Enhydra."
	@echo
